DEFINE CLASS boBase as Container
	
	*--- Abstract class name
	Name 				= "boBase"
	
	*--- References to Collaborating Objects
	oDataEnvironment 	= .NULL.
	oBehavior			= .NULL.
	oBizRules			= .NULL.
	
	*--- Unless you need a custom behavior
	*--- class the regular cursor class will do
	cBehavior 			= "CursorBehavior"
	
	*--- Init Event
	*--- Executes when object is instantiated
	PROCEDURE Init
		
		DO Setx
		
		*--- This object should not be
		*--- instantiated directly
		IF This.Name == "boBase"
			RETURN .F.
		ENDIF
		
		*--- Load the children objects
		This.LoadChildren()
		
	ENDPROC
	
	*--- LoadChildren Method
	*--- Loads children objects
	PROCEDURE LoadChildren
		
		This.oDataEnvironment 	= CREATEOBJECT(This.cDataEnvironment)
		This.oBehavior			= CREATEOBJECT(This.cBehavior)
		*This.oBizRules			= CREATEOBJECT(This.cBizRules)
		
	ENDPROC
	
	*--- SelectAlias Method
	*--- Selects the InitialSelectedAlias
	PROCEDURE SelectAlias
		
		*--- Set the appropriate Data Session
		SET DATASESSION TO This.oDataEnvironment.oSession.DataSessionID
		
		*--- Select the Initial Selected Alias
		SELECT (This.oDataEnvironment.InitialSelectedAlias)
		
	ENDPROC
	
	*--- First Method
	*--- Sets the pointer to the First Record
	PROCEDURE First
		
		LOCAL lcAlias, lnSession
		lcAlias = ALIAS()
		lnSession = SET("Datasession")
		
		*--- Set the appropriate Data Session
		SET DATASESSION TO This.GetSessionID()
		
		*--- Select the correct Alias
		This.SelectAlias()
		
		*--- Call the Data Behavior Class to
		*--- execute the appropriate call to
		*--- go to the first record
		This.oBehavior.First()
		
		*--- Set everything back the way it
		*--- prior to entering this method
		SET DATASESSION TO lnSession
		IF NOT EMPTY(lcAlias)
			SELECT (lcAlias)
		ENDIF
		
	ENDPROC
	
	*--- Next Method
	*--- Sets the pointer to the Next Record
	PROCEDURE Next
		
		LOCAL lcAlias, lnSession
		lcAlias = ALIAS()
		lnSession = SET("Datasession")
		
		*--- Set the appropriate Data Session
		SET DATASESSION TO This.GetSessionID()
		
		*--- Select the correct Alias
		This.SelectAlias()
		
		*--- Call the Data Behavior Class to
		*--- execute the appropriate call to
		*--- go to the first record
		This.oBehavior.Next()
		
		*--- Set everything back the way it
		*--- prior to entering this method
		SET DATASESSION TO lnSession
		IF NOT EMPTY(lcAlias)
			SELECT (lcAlias)
		ENDIF
		
	ENDPROC
	
	*--- Previous Method
	*--- Move the pointer to the previous record
	PROCEDURE Previous
		
		LOCAL lcAlias, lnSession
		lcAlias = ALIAS()
		lnSession = SET("Datasession")
		
		*--- Set the appropriate Data Session
		SET DATASESSION TO This.GetSessionID()
		
		*--- Select the correct Alias
		This.SelectAlias()
		
		*--- Call the Data Behavior Class to
		*--- execute the appropriate call to
		*--- go to the first record
		This.oBehavior.Previous()
		
		*--- Set everything back the way it
		*--- prior to entering this method
		SET DATASESSION TO lnSession
		IF NOT EMPTY(lcAlias)
			SELECT (lcAlias)
		ENDIF
		
	ENDPROC
	
	*--- First Method
	*--- Sets the pointer to the Last Record
	PROCEDURE Last
		
		LOCAL lcAlias, lnSession
		lcAlias = ALIAS()
		lnSession = SET("Datasession")
		
		*--- Set the appropriate Data Session
		SET DATASESSION TO This.GetSessionID()
		
		*--- Select the correct Alias
		This.SelectAlias()
		
		*--- Call the Data Behavior Class to
		*--- execute the appropriate call to
		*--- go to the first record
		This.oBehavior.Last()
		
		*--- Set everything back the way it
		*--- prior to entering this method
		SET DATASESSION TO lnSession
		IF NOT EMPTY(lcAlias)
			SELECT (lcAlias)
		ENDIF
		
	ENDPROC
	
	*--- GetSessionID Method
	*--- Returns the Data Session ID
	PROCEDURE GetSessionID
		
		RETURN This.oDataEnvironment.GetSessionID()
		
	ENDPROC
	
	*--- Requery Method
	*--- Calls the Cursor Behavior Class Requery Method
	PROCEDURE Requery
		
		LOCAL lcAlias, lnSession, lcInitialSelectedAlias
		lcAlias = ALIAS()
		lnSession = SET("Datasession")
		
		*--- Call the Data Behavior Class to
		*--- execute the appropriate call to
		*--- go to the first record
		This.oBehavior.Requery(This.GetAlias(), This.GetSessionID())
		
		*--- Set everything back the way it
		*--- prior to entering this method
		SET DATASESSION TO lnSession
		IF NOT EMPTY(lcAlias)
			SELECT (lcAlias)
		ENDIF
		
	ENDPROC
	
	*--- New Method
	*--- Calls the Cursor Behavior Class New Method
	PROCEDURE New
		
		LOCAL lcAlias, lnSession, lcInitialSelectedAlias
		lcAlias = ALIAS()
		lnSession = SET("Datasession")
		
		*--- Call the Data Behavior Class to
		*--- execute the appropriate call to
		*--- go to the first record
		This.oBehavior.New(This.GetAlias(), This.GetSessionID())
		
		*--- Set everything back the way it
		*--- prior to entering this method
		SET DATASESSION TO lnSession
		IF NOT EMPTY(lcAlias)
			SELECT (lcAlias)
		ENDIF
		
	ENDPROC
	
	*--- Save Method
	*--- Calls the Cursor Behavior Class Save Method
	PROCEDURE Save
		
		LOCAL lcAlias, lnSession, lcInitialSelectedAlias
		lcAlias = ALIAS()
		lnSession = SET("Datasession")
		
		*--- Call the Data Behavior Class to
		*--- execute the appropriate call to
		*--- go to the first record
		This.oBehavior.Save(This.GetAlias(), This.GetSessionID())
		
		*--- Set everything back the way it
		*--- prior to entering this method
		SET DATASESSION TO lnSession
		IF NOT EMPTY(lcAlias)
			SELECT (lcAlias)
		ENDIF
		
	ENDPROC
	
	*--- Delete Method
	*--- Calls the Cursor Behavior Class Delete Method
	PROCEDURE Delete
		
		LOCAL lcAlias, lnSession, lcInitialSelectedAlias
		lcAlias = ALIAS()
		lnSession = SET("Datasession")
		
		*--- Call the Data Behavior Class to
		*--- execute the appropriate call to
		*--- go to the first record
		This.oBehavior.Delete(This.GetAlias(), This.GetSessionID())
		
		*--- Set everything back the way it
		*--- prior to entering this method
		SET DATASESSION TO lnSession
		IF NOT EMPTY(lcAlias)
			SELECT (lcAlias)
		ENDIF
		
	ENDPROC
	
	*--- Cancel Method
	*--- Calls the Cursor Behavior Class Cancel Method
	PROCEDURE Cancel
		
		LOCAL lcAlias, lnSession, lcInitialSelectedAlias
		lcAlias = ALIAS()
		lnSession = SET("Datasession")
		
		*--- Call the Data Behavior Class to
		*--- execute the appropriate call to
		*--- go to the first record
		This.oBehavior.Cancel(This.GetAlias(), This.GetSessionID())
		
		*--- Set everything back the way it
		*--- prior to entering this method
		SET DATASESSION TO lnSession
		IF NOT EMPTY(lcAlias)
			SELECT (lcAlias)
		ENDIF
		
	ENDPROC
	
	*--- GetAlias Method
	*--- Calls the Data Environments Class GetAlias Method
	PROCEDURE GetAlias
		
		RETURN This.oDataEnvironment.GetAlias()
		
	ENDPROC
	
ENDDEFINE